string GetDescription()
{
	return "This is a very simple latin style arrangement.";
}

int GetRandom(int[] @patches)
{
	return patches[RndInt(0, patches.length()-1)];
}

void Arrange(Song @s)
{
	int bars = s.GetBars();	

	int[] patches = { 109, 107, 106, 12, 11, 13, 19, 76,78,80,72,65,47,24,23 , 73, 73, 73 };
	
	s.AddTrack("Melody", GetRandom(patches),127,64);
	s.AddTrack("Alt Voice", 2,127,64);
	s.AddTrack("Fill", 50,127,64);
	s.AddTrack("Bass", 33,127,64);
	if (RndInt(0,1) != 0) s.AddTrack("Accomp", RndInt(1,6),127,64); // accomp = piano
	else s.AddTrack("Accomp", 25,127,64); // accomp = guitar
	s.AddTrack("Drums", 1,127,64);

	int chorus_seed = RndInt(0,32000);
	int normal_seed = RndInt(0,32000);
	
	
	for (int i = 0; i < s.GetParts(); i++)
	{
		if (s.GetPart(i).GetArrHint() == 0)
		{
			
		}
		
		if (s.GetPart(i).GetArrHint() == 1)
		{
			s.AddRenderEvent("Simple Melody", RndInt(0,32000), 0, s.GetPartStartBar(i), s.GetPartEndBar(i), 2, CreateTime(0,0),0.95); 		
		}
		
		if (s.GetPart(i).GetArrHint() == 2)
		{
			s.AddRenderEvent("Simple Melody", RndInt(0,32000), 1, s.GetPartStartBar(i), s.GetPartEndBar(i), 2, CreateTime(0,0),0.95); 		
		}
		
		if (s.GetPart(i).GetArrHint() == 3)
		{
			s.AddRenderEvent("Simple Melody", RndInt(0,32000), 0, s.GetPartStartBar(i), s.GetPartEndBar(i), 2, CreateTime(0,0),1.0); 		
			s.AddRenderEvent("Chordal Melody", RndInt(0,32000), 1, s.GetPartStartBar(i), s.GetPartEndBar(i), 2, CreateTime(0,0),1.0); 		
			s.AddRenderEvent("Latin Chords", chorus_seed, 4,s.GetPartStartBar(i), s.GetPartEndBar(i), 1, CreateTime(0,0),0.9); 
			s.AddRenderEvent("Latin Bass", RndInt(0,32000), 3,s.GetPartStartBar(i), s.GetPartEndBar(i), -1, CreateTime(0,0),1.0); 
			s.AddRenderEvent("Shortest Way Chords Simple", RndInt(0,32000), 2,s.GetPartStartBar(i), s.GetPartEndBar(i), 1, CreateTime(0,0),0.65); 
			s.AddRenderEvent("Drums - Latin", chorus_seed, 5,s.GetPartStartBar(i), s.GetPartEndBar(i), 1, CreateTime(0,0),0.85); 
		}
		else
		{
			s.AddRenderEvent("Latin Chords", normal_seed, 4,s.GetPartStartBar(i), s.GetPartEndBar(i), 1, CreateTime(0,0),0.75); 	
			s.AddRenderEvent("Latin Bass", RndInt(0,32000), 3,s.GetPartStartBar(i), s.GetPartEndBar(i), -1, CreateTime(0,0),0.95); 
			s.AddRenderEvent("Shortest Way Chords Simple", RndInt(0,32000), 2,s.GetPartStartBar(i), s.GetPartEndBar(i), 1, CreateTime(0,0),0.5); 
			s.AddRenderEvent("Drums - Latin", normal_seed, 5,s.GetPartStartBar(i), s.GetPartEndBar(i), 1, CreateTime(0,0),0.8); 
		}
	}
			
	
		
}